using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Spells;

namespace Server.Mobiles
{
	//[CorpseName( "an ophidian corpse" )]
	[TypeAlias( "Server.Mobiles.OphidianShaman" )]
	public class IceOphidianMage : OphidianMage
	{
		private DateTime m_Summon = DateTime.Now;
      
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.MortalStrike;
					case 2: return WeaponAbility.CrushingBlow;
			}
		}
      
      [Constructable]
		public IceOphidianMage() : base()
		{
         Hue = 196;
			Name = "ophidiansky mag";
         
			SetStr( 505, 700 );
			SetDex( 202, 300 );
			SetInt( 502, 600 );

			SetHits( 1000, 1500 );
			SetStam( 305, 600 );
			SetMana( 800, 1000 );

			SetDamage( 20, 25 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Poison, 60 );

			SetResistance( ResistanceType.Physical, 60, 80 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 80 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.MagicResist, 90.7, 140.0 );
			SetSkill( SkillName.Tactics, 97.6, 100.0 );
			SetSkill( SkillName.Wrestling, 97.6, 100.0 );
			SetSkill( SkillName.Anatomy, 97.6, 100.0 );
			SetSkill( SkillName.Magery, 100.0, 120.0 );
			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Poisoning, 120.1, 140.0 );
			
			Fame = 6000;
			Karma = -9500;

			VirtualArmor = 80;
			Tamable = false;

			PackReg( 10 );
		}

		public override int Meat{ get{ return 1; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
      
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && DateTime.Now > m_Summon )
			{
				Mobile target = this.Combatant;				
				this.Frozen = false;

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = new FrostSpider();

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 2 ) - 1;
					int y = Y + Utility.Random( 2 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.SetHits( 5000, 6000 );
				animal.SetDamage( 15, 20 );
			   animal.SetSkill( SkillName.Tactics, 97.6, 100.0 );
			   animal.SetSkill( SkillName.Wrestling, 97.6, 100.0 );
            animal.Tamable = false;
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;
				
				TimeSpan duration = TimeSpan.FromSeconds( 60.0 );
				new UnsummonTimer( this, animal, duration ).Start();
				animal.SummonEnd = DateTime.Now + duration;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( 30.0 );
			}
			base.OnActionCombat();
		}
      
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Miscellaneous );
			AddLoot( LootPack.HighScrolls, 4 );
		}

		public IceOphidianMage( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}